/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.mainmenu;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import moe.plushie.armourers_workshop.api.ArmourersWorkshopClientApi;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.api.entity.data.ICustomDrop;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.client.util.aw.ArmourersWorkshopUtil;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerNPCInv;
import noppes.npcs.controllers.DropController;
import noppes.npcs.controllers.data.DropsTemplate;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.util.Util;

public class GuiNPCInv
extends GuiContainerNPCInterface2
implements ISubGuiListener,
ICustomScrollListener,
IGuiData,
GuiYesNoCallback,
ITextfieldListener {
    private final ContainerNPCInv container;
    private final Map<String, DropSet> dropsData = new HashMap<String, DropSet>();
    private final DataInventory inventory;
    private DropsTemplate temp;
    private int groupId;
    private GuiCustomScroll scrollTemplate;
    private GuiCustomScroll scrollDrops;
    private final EntityNPCInterface displayNpc;

    public GuiNPCInv(EntityNPCInterface npc, ContainerNPCInv cont) {
        super(npc, cont, 3);
        this.setBackground("npcinv.png");
        this.container = cont;
        this.field_147000_g = 200;
        this.displayNpc = Util.instance.copyToGUI(npc, (World)this.field_146297_k.field_71441_e, false);
        this.groupId = 0;
        this.inventory = npc.inventory;
        Client.sendData(EnumPacketServer.MainmenuInvGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.inventory.dropType = button.getValue();
                this.func_73866_w_();
                break;
            }
            case 1: {
                NoppesUtil.requestOpenGUI(EnumGuiType.MainMenuInvDrop, this.inventory.dropType, this.groupId, -1);
                break;
            }
            case 2: {
                if (this.scrollDrops.getSelect() == -1) {
                    return;
                }
                NoppesUtil.requestOpenGUI(EnumGuiType.MainMenuInvDrop, this.inventory.dropType, this.groupId, this.scrollDrops.getSelect());
                break;
            }
            case 3: {
                if (this.scrollDrops.getSelect() == -1) {
                    return;
                }
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("Item", (NBTBase)ItemStack.field_190927_a.func_77955_b(new NBTTagCompound()));
                Client.sendData(EnumPacketServer.MainmenuInvDropSave, this.inventory.dropType, this.groupId, this.scrollDrops.getSelect(), compound);
                break;
            }
            case 4: {
                this.setSubGui(new SubGuiEditText(1, Util.instance.deleteColor(new TextComponentTranslation("gui.new", new Object[0]).func_150254_d())));
                break;
            }
            case 5: {
                if (this.scrollTemplate == null || !this.scrollTemplate.hasSelected() || this.temp == null) {
                    return;
                }
                String name = this.scrollTemplate.getSelected();
                DropsTemplate dt = DropsTemplate.from(this.temp);
                DropController dData = DropController.getInstance();
                while (dData.templates.containsKey(name)) {
                    name = name + "_";
                }
                this.inventory.saveDropsName = name;
                dData.templates.put(this.inventory.saveDropsName, dt);
                this.temp = dt;
                this.func_73866_w_();
                break;
            }
            case 6: {
                this.setSubGui(new SubGuiEditText(2, this.inventory.saveDropsName));
                break;
            }
            case 7: {
                if (this.scrollTemplate == null || !this.scrollTemplate.hasSelected()) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.scrollTemplate.getSelected(), new TextComponentTranslation("gui.clearMessage", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
            }
            case 8: {
                this.groupId = button.getValue();
                this.func_73866_w_();
                break;
            }
            case 9: {
                this.groupId = this.temp.groups.size();
                this.temp.groups.put(this.groupId, new TreeMap());
                this.func_73866_w_();
                break;
            }
            case 10: {
                this.inventory.lootMode = button.getValue() == 1;
                break;
            }
            case 11: {
                if (this.temp == null) {
                    return;
                }
                Map<Integer, DropSet> parent = this.temp.groups.get(this.groupId);
                TreeMap<Integer, DropSet> newGroup = new TreeMap<Integer, DropSet>();
                for (int id : parent.keySet()) {
                    DropSet ds = new DropSet(this.inventory);
                    ds.load(parent.get(id).getNBT());
                    newGroup.put(id, ds);
                }
                this.groupId = this.temp.groups.size();
                this.temp.groups.put(this.groupId, newGroup);
                this.func_73866_w_();
                break;
            }
            case 12: {
                if (this.temp == null || this.temp.groups.isEmpty() || this.groupId <= 0) {
                    return;
                }
                if (this.temp.groups.get(this.groupId).isEmpty()) {
                    this.temp.removeGroup(this.groupId);
                    --this.groupId;
                    this.func_73866_w_();
                    break;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("gui.group", new Object[0]).func_150254_d() + " ID: " + this.groupId, new TextComponentTranslation("gui.clearMessage", new Object[0]).func_150254_d(), 1);
                this.displayGuiScreen((GuiScreen)guiyesno);
            }
        }
    }

    private void saveTemplate() {
        if (this.inventory.dropType == 1 && this.inventory.saveDropsName != null && !this.inventory.saveDropsName.isEmpty()) {
            DropController.getInstance().sendToServer(this.inventory.saveDropsName);
        }
    }

    public void func_73878_a(boolean result, int id) {
        this.displayGuiScreen((GuiScreen)this);
        if (!result) {
            return;
        }
        if (id == 0) {
            if (this.scrollTemplate == null || !this.scrollTemplate.hasSelected()) {
                return;
            }
            DropController.getInstance().templates.remove(this.scrollTemplate.getSelected());
            Client.sendDirectData(EnumPacketServer.DropTemplateSave, 2, this.scrollTemplate.getSelected());
            this.func_73866_w_();
        } else if (id == 1) {
            if (this.temp == null || this.temp.groups.isEmpty()) {
                return;
            }
            this.temp.removeGroup(this.groupId);
            --this.groupId;
            this.func_73866_w_();
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int id = 4; id <= 8; ++id) {
            Slot slot = this.container.func_75139_a(id);
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            if (id > 6 && ArmourersWorkshopClientApi.getSkinRenderHandler() != null) {
                this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 0, 0, 18, 18);
                if (slot.func_75216_d()) continue;
                this.field_146297_k.func_110434_K().func_110577_a(id == 7 ? ArmourersWorkshopUtil.getInstance().slotOutfit : ArmourersWorkshopUtil.getInstance().slotWings);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.field_147003_i + slot.field_75223_e), (float)(this.field_147009_r + slot.field_75221_f), (float)0.0f);
                GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0625f);
                this.func_73729_b(0, 0, 0, 0, 256, 256);
                GlStateManager.func_179121_F();
                continue;
            }
            if (!slot.func_75216_d()) continue;
            this.func_73729_b(this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, 0, 0, 18, 18);
        }
        int color = new Color(-10461088).getRGB();
        if (this.inventory.dropType != 0) {
            this.func_73728_b(this.field_147003_i + 274, this.field_147009_r + 26, this.field_147009_r + this.field_147000_g + 12, color);
        }
        if (this.inventory.dropType == 1) {
            this.func_73728_b(this.field_147003_i + 327, this.field_147009_r + 162, this.field_147009_r + this.field_147000_g + 12, color);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (int i = 0; i < 4; ++i) {
            this.displayNpc.inventory.setArmor(i, this.npc.inventory.getArmor(i));
        }
        this.displayNpc.inventory.setRightHand(this.npc.inventory.getRightHand());
        this.displayNpc.inventory.setProjectile(this.npc.inventory.getProjectile());
        this.displayNpc.inventory.setLeftHand(this.npc.inventory.getLeftHand());
        this.displayNpc.field_70173_aa = this.npc.field_70173_aa;
        this.drawNpc((Entity)this.displayNpc, 50, 84, 1.0f, 0, 0, 1);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(new GuiNpcLabel(0, "inv.minExp", this.field_147003_i + 108, this.field_147009_r + 18));
        GuiNpcTextField textField = new GuiNpcTextField(0, (GuiScreen)this, this.field_146289_q, this.field_147003_i + 108, this.field_147009_r + 29, 60, 20, this.inventory.getExpMin() + "");
        textField.setMinMaxDefault(0L, 32767L, 0L);
        textField.setHoverText("inv.hover.drops.minxp", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(1, "inv.maxExp", this.field_147003_i + 108, this.field_147009_r + 52));
        textField = new GuiNpcTextField(1, (GuiScreen)this, this.field_146289_q, this.field_147003_i + 108, this.field_147009_r + 63, 60, 20, this.inventory.getExpMax() + "");
        textField.setMinMaxDefault(0L, 32767L, 0L);
        textField.setHoverText("inv.hover.drops.maxxp", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcButton(10, this.field_147003_i + 107, this.field_147009_r + 88, 62, 20, new String[]{"stats.normal", "inv.auto"}, this.inventory.lootMode ? 1 : 0);
        button.setHoverText("inv.hover.auto.xp", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(2, "inv.npcInventory", this.field_147003_i + 191, this.field_147009_r + 5));
        this.addLabel(new GuiNpcLabel(3, "inv.inventory", this.field_147003_i + 8, this.field_147009_r + 101));
        button = new GuiNpcButton(0, this.field_147003_i + 175, this.field_147009_r + 4, 120, 20, new String[]{"inv.use.drops.0", "inv.use.drops.1", "inv.use.drops.2"}, this.inventory.dropType);
        button.setHoverText("inv.hover.drops.type", new Object[0]);
        this.addButton(button);
        textField = new GuiNpcTextField(2, (GuiScreen)this, this.field_147003_i + 300, this.field_147009_r + 4, 60, 20, "" + this.inventory.limitation);
        textField.setMinMaxDefault(0L, 128L, this.inventory.limitation);
        textField.setHoverText("inv.hover.drops.amount", new Object[0]);
        this.addTextField(textField);
        this.dropsData.clear();
        this.temp = null;
        String dropName = "";
        if (this.scrollDrops != null && this.scrollDrops.getSelected() != null && this.dropsData.get(this.scrollDrops.getSelected()) != null) {
            dropName = this.dropsData.get(this.scrollDrops.getSelected()).getItem().getDisplayName();
        }
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        LogWriter.debug("Inventory drop type: " + this.inventory.dropType);
        if (this.inventory.dropType == 0) {
            if (this.inventory.getDrops().length > 0) {
                int i = 0;
                for (ICustomDrop ids : this.inventory.getDrops()) {
                    DropSet ds = (DropSet)ids;
                    this.dropsData.put(ds.getKey(), ds);
                    hts.put(i++, ds.getHover((EntityPlayer)this.player));
                    stacks.add(ds.item.getMCItemStack());
                }
            }
            if (this.scrollDrops == null) {
                this.scrollDrops = new GuiCustomScroll(this, 1);
            }
            this.scrollDrops.setSize(238, 157);
            this.scrollDrops.setList(new ArrayList<String>(this.dropsData.keySet()));
            this.scrollDrops.guiLeft = this.field_147003_i + 175;
            this.scrollDrops.guiTop = this.field_147009_r + 38;
            this.scrollDrops.setHoverTexts(hts);
            this.scrollDrops.setStacks(stacks);
            this.addScroll(this.scrollDrops);
            this.addLabel(new GuiNpcLabel(4, "inv.drops", this.field_147003_i + 176, this.field_147009_r + 27));
            button = new GuiNpcButton(1, this.field_147003_i + 175, this.field_147009_r + 197, 60, 15, "gui.add", this.dropsData.size() < CustomNpcs.MaxItemInDropsNPC);
            button.setHoverText("inv.hover.add.drop", "" + CustomNpcs.MaxItemInDropsNPC);
            this.addButton(button);
            button = new GuiNpcButton(2, this.field_147003_i + 240, this.field_147009_r + 197, 60, 15, "selectServer.edit", this.scrollDrops.getSelect() >= 0);
            button.setHoverText("inv.hover.edit.drop", dropName);
            this.addButton(button);
            button = new GuiNpcButton(3, this.field_147003_i + 305, this.field_147009_r + 197, 60, 15, "gui.remove", this.scrollDrops.getSelect() >= 0);
            button.setHoverText("inv.hover.del.drop", dropName);
            this.addButton(button);
        } else if (this.inventory.dropType == 1) {
            this.addLabel(new GuiNpcLabel(4, "gui.templates", this.field_147003_i + 176, this.field_147009_r + 27));
            if (this.scrollTemplate == null) {
                this.scrollTemplate = new GuiCustomScroll(this, 0);
            }
            this.scrollTemplate.setSize(98, 140);
            this.scrollTemplate.setList(new ArrayList<String>(DropController.getInstance().templates.keySet()));
            this.scrollTemplate.guiLeft = this.field_147003_i + 175;
            this.scrollTemplate.guiTop = this.field_147009_r + 38;
            this.addScroll(this.scrollTemplate);
            if (DropController.getInstance().templates.containsKey(this.inventory.saveDropsName)) {
                this.temp = DropController.getInstance().templates.get(this.inventory.saveDropsName);
                this.scrollTemplate.setSelected(this.inventory.saveDropsName);
                if (this.temp.groups.containsKey(this.groupId)) {
                    int i = 0;
                    for (DropSet ds : this.temp.groups.get(this.groupId).values()) {
                        this.dropsData.put(ds.getKey(), ds);
                        hts.put(i++, ds.getHover((EntityPlayer)this.player));
                        stacks.add(ds.item.getMCItemStack());
                    }
                }
            } else {
                this.groupId = 0;
            }
            button = new GuiNpcButton(4, this.field_147003_i + 175, this.field_147009_r + 180, 48, 15, "gui.add", true);
            button.setHoverText("inv.hover.new.template", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(5, this.field_147003_i + 175, this.field_147009_r + 197, 48, 15, "gui.copy", !this.inventory.saveDropsName.isEmpty() && !this.inventory.saveDropsName.equals("default"));
            button.setHoverText("inv.hover.copy.template", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(6, this.field_147003_i + 225, this.field_147009_r + 180, 48, 15, "selectServer.edit", !this.inventory.saveDropsName.isEmpty() && !this.inventory.saveDropsName.equals("default"));
            button.setHoverText("inv.hover.rename.template", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(7, this.field_147003_i + 225, this.field_147009_r + 197, 48, 15, "gui.remove", !this.inventory.saveDropsName.isEmpty() && !this.inventory.saveDropsName.equals("default"));
            button.setHoverText("inv.hover.del.template", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(5, "gui.groups", this.field_147003_i + 277, this.field_147009_r + 30));
            ArrayList<String> l = new ArrayList<String>();
            int g = 1;
            if (this.temp != null && !this.temp.groups.isEmpty()) {
                g = this.temp.groups.size();
            }
            for (int i = 0; i < g; ++i) {
                l.add(i + 1 + " / " + g);
            }
            button = new GuiButtonBiDirectional(8, this.field_147003_i + 346, this.field_147009_r + 27, 70, 15, l.toArray(new String[0]), this.groupId);
            button.setHoverText("inv.hover.group.id", new Object[0]);
            this.addButton(button);
            if (this.scrollDrops == null) {
                this.scrollDrops = new GuiCustomScroll(this, 1);
            }
            this.scrollDrops.setSize(140, 117);
            this.scrollDrops.setList(new ArrayList<String>(this.dropsData.keySet()));
            this.scrollDrops.guiLeft = this.field_147003_i + 276;
            this.scrollDrops.guiTop = this.field_147009_r + 44;
            this.scrollDrops.setHoverTexts(hts);
            this.scrollDrops.setStacks(stacks);
            this.addScroll(this.scrollDrops);
            button = new GuiNpcButton(1, this.field_147003_i + 330, this.field_147009_r + 163, 48, 15, "gui.add", !this.inventory.saveDropsName.isEmpty());
            button.setHoverText("inv.hover.add.drop", "9000");
            this.addButton(button);
            button = new GuiNpcButton(2, this.field_147003_i + 330, this.field_147009_r + 180, 48, 15, "selectServer.edit", this.scrollDrops.getSelected() != null);
            button.setHoverText("inv.hover.edit.drop", dropName);
            this.addButton(button);
            button = new GuiNpcButton(3, this.field_147003_i + 330, this.field_147009_r + 197, 48, 15, "gui.remove", this.scrollDrops.hasSelected() && (!this.inventory.saveDropsName.equals("default") || this.scrollDrops.getSelect() >= 4));
            button.setHoverText("inv.hover.del.drop", dropName);
            this.addButton(button);
            button = new GuiNpcButton(9, this.field_147003_i + 277, this.field_147009_r + 163, 48, 15, "gui.add", true);
            button.setHoverText("inv.hover.add.group", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(11, this.field_147003_i + 277, this.field_147009_r + 180, 48, 15, "gui.copy", this.temp != null && this.temp.groups.containsKey(this.groupId));
            button.setHoverText("inv.hover.copy.group", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(12, this.field_147003_i + 277, this.field_147009_r + 197, 48, 15, "gui.remove", this.temp != null && this.temp.groups.containsKey(this.groupId) && this.groupId > 0);
            button.setHoverText("inv.hover.del.group", new Object[0]);
            this.addButton(button);
        } else {
            this.addLabel(new GuiNpcLabel(4, "gui.templates", this.field_147003_i + 176, this.field_147009_r + 27));
            this.addLabel(new GuiNpcLabel(5, "inv.drops", this.field_147003_i + 277, this.field_147009_r + 27));
            if (this.inventory.getDrops().length > 0) {
                int i = 0;
                for (ICustomDrop ids : this.inventory.getDrops()) {
                    DropSet ds = (DropSet)ids;
                    this.dropsData.put(ds.getKey(), ds);
                    hts.put(i++, ds.getHover((EntityPlayer)this.player));
                    stacks.add(ds.item.getMCItemStack());
                }
            }
            if (this.scrollTemplate == null) {
                this.scrollTemplate = new GuiCustomScroll(this, 0);
            }
            this.scrollTemplate.setSize(98, 174);
            this.scrollTemplate.setList(new ArrayList<String>(DropController.getInstance().templates.keySet()));
            this.scrollTemplate.guiLeft = this.field_147003_i + 175;
            this.scrollTemplate.guiTop = this.field_147009_r + 38;
            this.addScroll(this.scrollTemplate);
            if (DropController.getInstance().templates.containsKey(this.inventory.saveDropsName)) {
                this.temp = DropController.getInstance().templates.get(this.inventory.saveDropsName);
                this.scrollTemplate.setSelected(this.inventory.saveDropsName);
            } else {
                this.groupId = 0;
            }
            if (this.scrollDrops == null) {
                this.scrollDrops = new GuiCustomScroll(this, 1);
            }
            this.scrollDrops.setSize(140, 157);
            this.scrollDrops.setList(new ArrayList<String>(this.dropsData.keySet()));
            this.scrollDrops.guiLeft = this.field_147003_i + 276;
            this.scrollDrops.guiTop = this.field_147009_r + 38;
            this.scrollDrops.setHoverTexts(hts);
            this.scrollDrops.setStacks(stacks);
            this.addScroll(this.scrollDrops);
            button = new GuiNpcButton(1, this.field_147003_i + 277, this.field_147009_r + 197, 45, 15, "gui.add", this.dropsData.size() < CustomNpcs.MaxItemInDropsNPC);
            button.setHoverText("inv.hover.add.drop", "" + CustomNpcs.MaxItemInDropsNPC);
            this.addButton(button);
            button = new GuiNpcButton(2, this.field_147003_i + 324, this.field_147009_r + 197, 45, 15, "selectServer.edit", this.scrollDrops.getSelect() >= 0);
            button.setHoverText("inv.hover.edit.drop", dropName);
            this.addButton(button);
            button = new GuiNpcButton(3, this.field_147003_i + 371, this.field_147009_r + 197, 45, 15, "gui.remove", this.scrollDrops.getSelect() >= 0);
            button.setHoverText("inv.hover.del.drop", dropName);
            this.addButton(button);
        }
    }

    @Override
    public void save() {
        this.saveTemplate();
        Client.sendData(EnumPacketServer.MainmenuInvSave, this.inventory.writeEntityToNBT(new NBTTagCompound()));
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getSelected() == null) {
            return;
        }
        if (scroll.getID() == 0) {
            this.saveTemplate();
            if (scroll.getSelected().equals(this.inventory.saveDropsName)) {
                this.inventory.saveDropsName = "";
                scroll.setSelected(null);
            } else {
                this.inventory.saveDropsName = scroll.getSelected();
            }
            Client.sendData(EnumPacketServer.MainmenuInvSave, this.inventory.writeEntityToNBT(new NBTTagCompound()));
            if (this.inventory.dropType == 1) {
                this.groupId = 0;
            }
            this.func_73866_w_();
        }
        if (scroll.getID() == 1) {
            this.func_73866_w_();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (scroll.getID() == 1 && this.dropsData.get(this.scrollDrops.getSelected()) != null) {
            this.saveTemplate();
            NoppesUtil.requestOpenGUI(EnumGuiType.MainMenuInvDrop, this.inventory.dropType, this.groupId, this.scrollDrops.getSelect());
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.inventory.readEntityFromNBT(compound);
        this.func_73866_w_();
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (!(subgui instanceof SubGuiEditText) || ((SubGuiEditText)subgui).cancelled) {
            return;
        }
        DropController dData = DropController.getInstance();
        String name = ((SubGuiEditText)subgui).text[0];
        if (subgui.getId() == 1) {
            while (dData.templates.containsKey(name)) {
                name = name + "_";
            }
            this.inventory.saveDropsName = name;
            dData.templates.put(this.inventory.saveDropsName, new DropsTemplate());
            NBTTagCompound nbtTemplate = new NBTTagCompound();
            nbtTemplate.func_74778_a("Name", name);
            nbtTemplate.func_74782_a("Groups", (NBTBase)dData.templates.get(this.inventory.saveDropsName).getNBT());
            Client.sendDirectData(EnumPacketServer.DropTemplateSave, 1, nbtTemplate);
        } else if (subgui.getId() == 2) {
            if (name == null || name.equals(this.inventory.saveDropsName) || dData.templates.containsKey(name) || !dData.templates.containsKey(this.inventory.saveDropsName)) {
                return;
            }
            dData.templates.put(name, dData.templates.get(this.inventory.saveDropsName));
            dData.templates.remove(this.inventory.saveDropsName);
            Client.sendDirectData(EnumPacketServer.DropTemplateSave, 2, this.inventory.saveDropsName);
            NBTTagCompound nbtTemplate = new NBTTagCompound();
            nbtTemplate.func_74778_a("Name", name);
            nbtTemplate.func_74782_a("Groups", (NBTBase)dData.templates.get(name).getNBT());
            Client.sendDirectData(EnumPacketServer.DropTemplateSave, 1, nbtTemplate);
        }
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        switch (textField.getID()) {
            case 0: {
                this.inventory.setExp(textField.getInteger(), this.getTextField(1).getInteger());
                break;
            }
            case 1: {
                this.inventory.setExp(this.getTextField(0).getInteger(), textField.getInteger());
                break;
            }
            case 2: {
                this.inventory.limitation = this.getTextField(2).getInteger();
            }
        }
    }
}

